﻿using UnityEngine;
using UnityEditor;
using System.Collections;
using System.IO;
using System.Text;
using System;
using TMPro;

public class TPMAutoZeroOne
{
	[MenuItem("Zero One/Convert TMPro to Zero One")]
	static void ConvertTMP()
	{
		GameObject go = Selection.activeGameObject;

		if (go == null)
		{
			EditorUtility.DisplayDialog("Alert", "no selection", "OK");
		}

		if (go.TryGetComponent(out TextMeshProUGUI textMeshProUGUI))		
		{
			TextMeshProUGUI oldComponent = go.GetComponent<TextMeshProUGUI>();

			GameObject copyGameObject = GameObject.Instantiate(go, go.transform.parent);
			
			TextMeshProUGUI copyComponent = copyGameObject.GetComponent<TextMeshProUGUI>();
			GameObject.DestroyImmediate(copyComponent);

			TextMeshProZO newComponent = copyGameObject.AddComponent<TextMeshProZO>();
			newComponent.GetCopyOfPublic(oldComponent);

			int oldIndex = go.transform.GetSiblingIndex();
			newComponent.transform.SetSiblingIndex(oldIndex);

			GameObject.DestroyImmediate(go);

			Selection.activeGameObject = copyGameObject;

			EditorUtility.DisplayDialog("Result", "New TextMeshProZO Created!\nDon't forget to relink the scripts", "OK");
		}
		else
		{
			EditorUtility.DisplayDialog("Alert", "no TMPro in selection", "OK");
		}
	}
}